DELIMITER $$
DROP PROCEDURE IF EXISTS V20220301182044__Insert_RBU_HallTicket $$
CREATE PROCEDURE V20220301182044__Insert_RBU_HallTicket()
BEGIN

set @rbuHallTicket = (select max(id) from report_type where typeName='Hall Ticket' );
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'RBU_HALL_TICKET')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@rbuHallTicket, 'RBU_HALL_TICKET', 'RBU Hall Ticket', 'RBU_HALL_TICKET.png', 'CommonReport_RBU.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RBU_HALL_TICKET.jasper', 'AcademiaLogo.png');
END IF; 


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'RBU_HALL_TICKET')) THEN 
set @rbu = (select id from report_template where templateCode ='RBU_HALL_TICKET');


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_SESSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_SESSION', 'Session', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_DELIMITER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_DELIMITER', ':', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_SCHOOL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_SCHOOL', 'Name of the School', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_EXAMINATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_EXAMINATION', 'Name of the Examination', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_STUDENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_STUDENT', 'Name of the Student', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_MOTHERS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_MOTHERS_NAME', 'Mother’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_FATHERS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_FATHERS_NAME', 'Father’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_GENDER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_GENDER', 'Gender', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_EXAMINEE_CATEGORY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_EXAMINEE_CATEGORY', 'Examinee Category', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_ROLL_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_ROLL_NO', 'Roll No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_REGISTRATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_REGISTRATION', 'Registration No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_MEDIUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_MEDIUM', 'Medium', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_MEDIUM_VALUE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_MEDIUM_VALUE', 'ENGLISH', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_MEDIUM_VALUE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_MEDIUM_VALUE', 'ENGLISH', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_SRNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_SRNO', 'Sr. No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_COURSE_CODE', 'Course Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_EXAMINATION_DATES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_EXAMINATION_DATES', 'Date of Examination', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_EXAMINATION_TIME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_EXAMINATION_TIME', 'Timings of Examinations', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_INVIGILATOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_INVIGILATOR', 'Signature of Invigilator', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_CENTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_CENTER', 'Centre Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_TEXT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_TEXT', 'ADMIT CARD FOR THE EXAMINATIONS/RE-EXAMINATIONS', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_COURSES_OFFERED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_COURSES_OFFERED', 'Courses Offered/ Schedule:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_SEAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_SEAL', 'Seal', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_EXAMINATION_CONTROLLER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_EXAMINATION_CONTROLLER', 'Controller of Examinations', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rbu and keyValue='TRANS_STUDENT_SIGN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rbu, 'TRANS_STUDENT_SIGN', 'Student Signature', '1', now());
END IF;

END IF;
END $$
CALL V20220301182044__Insert_RBU_HallTicket() $$
DROP PROCEDURE IF EXISTS V20220301182044__Insert_RBU_HallTicket $$
DELIMITER ;
