DELIMITER $$
DROP PROCEDURE IF EXISTS V20220506085955__Insert_MakePaymentErrorMsgTranslation $$
CREATE PROCEDURE V20220506085955__Insert_MakePaymentErrorMsgTranslation()
BEGIN

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='PLEASE_PAY_FOR_HOSTEL_FEE_SEPARATELY_IT_SHOULD_NOT_BE_COMBINED_WITH_OTHER_FEES' 
AND objectName='PERSON')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('PERSON','PLEASE_PAY_FOR_HOSTEL_FEE_SEPARATELY_IT_SHOULD_NOT_BE_COMBINED_WITH_OTHER_FEES',
'Please pay for Hostel Fee separately. It should not be combined with other fees.',
'Please pay for Hostel Fee separately. It should not be combined with other fees.',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER' 
AND objectName='PERSON')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('PERSON','YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER',
'You cannot make payment for the Hostel fee. Please try again later',
'You cannot make payment for the Hostel fee. Please try again later',now(),1);
END IF;  

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='IS_HOSTEL_FEE' AND objectName='FEEANDPAYMENTS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('FEEANDPAYMENTS','IS_HOSTEL_FEE',
'Is Hostel Fee','Is Hostel Fee',now(),1);
END IF;

END $$
CALL V20220506085955__Insert_MakePaymentErrorMsgTranslation() $$
DROP PROCEDURE IF EXISTS V20220506085955__Insert_MakePaymentErrorMsgTranslation $$
DELIMITER ;