DELIMITER $$
DROP PROCEDURE IF EXISTS V20220804155406__Create_ConcessionDependentSRDetail $$
CREATE PROCEDURE V20220804155406__Create_ConcessionDependentSRDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='concesession_dependent_servicrequest_detail' )) THEN 
CREATE TABLE `concesession_dependent_servicrequest_detail` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `dependentFieldId` BIGINT NOT NULL,
  `serviceRequestId` BIGINT NOT NULL,
  `concessionDurationDetailId` BIGINT NOT NULL,
  `fieldName` VARCHAR(255) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `examConcesession_dependent_lastUpdatedby` (`lastUpdatedBy` ASC) ,
  INDEX `examConcession_dependentField_dependentFieldId` (`dependentFieldId` ASC) ,
  INDEX `exam_concession_durationDetailId` (`concessionDurationDetailId` ASC) ,
  INDEX `exam_concession_serviceRequestId` (`serviceRequestId` ASC) ,
  CONSTRAINT `exam_concession_sr_detail_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_concession_dependentField`
	FOREIGN KEY (`dependentFieldId`)
	REFERENCES `exam_concession_dependent_field` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_concession_serviceRequest`
	FOREIGN KEY (`serviceRequestId`)
	REFERENCES `service_requests` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_concession_durationDetailId`
	FOREIGN KEY (`concessionDurationDetailId`)
	REFERENCES `exam_concesession_duration_detail` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20220804155406__Create_ConcessionDependentSRDetail () $$ 
DROP PROCEDURE IF EXISTS V20220804155406__Create_ConcessionDependentSRDetail $$ 
DELIMITER ;