DELIMITER $$
DROP PROCEDURE IF EXISTS V20220818120802__Create_PeriodDetailsCampus $$
CREATE PROCEDURE V20220818120802__Create_PeriodDetailsCampus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='period_details_campus')) THEN

CREATE TABLE `period_details_campus` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `academyCampusId` BIGINT(20) NOT NULL,
  `programBatchPeriodConfigurationId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_applicant_person_interventions_idx` (`academyCampusId` ASC),
  INDEX `fk_applicant_person_Id_idx` (`programBatchPeriodConfigurationId` ASC),
  INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_period_details_campus_id`
    FOREIGN KEY (`academyCampusId`)
    REFERENCES `academy_location_campus` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_period_details_campus_programbatchperiodid`
    FOREIGN KEY (`programBatchPeriodConfigurationId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_period_details_campus_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20220818120802__Create_PeriodDetailsCampus () $$ 
DROP PROCEDURE IF EXISTS V20220818120802__Create_PeriodDetailsCampus $$ 
DELIMITER ;