DELIMITER $$
DROP PROCEDURE IF EXISTS V20221011095512__Create_MutuallyExclusiveCourseGroup $$
CREATE PROCEDURE V20221011095512__Create_MutuallyExclusiveCourseGroup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_group_mutually_exclusive')) THEN
CREATE TABLE `course_group_mutually_exclusive` (
 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
 `courseGroupId` BIGINT(20) NOT NULL,
 `mutuallyExclusiveCourseGroupId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
 `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 INDEX `fk_course_group_Id_idx` (`courseGroupId` ASC),
 INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
 CONSTRAINT `fk_course_group_Id_id`
 FOREIGN KEY (`courseGroupId`)
REFERENCES `course_group` (`id`)   
ON DELETE RESTRICT
ON UPDATE RESTRICT);

ALTER TABLE `course_group_mutually_exclusive` 
ADD CONSTRAINT `fk_mutually_exclusive_id_idx`
  FOREIGN KEY (`mutuallyExclusiveCourseGroupId`)
  REFERENCES `course_group` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  END IF;
END $$
CALL V20221011095512__Create_MutuallyExclusiveCourseGroup () $$ 
DROP PROCEDURE IF EXISTS V20221011095512__Create_MutuallyExclusiveCourseGroup $$ 
DELIMITER ;