DELIMITER $$
DROP PROCEDURE IF EXISTS V20221209184743__Create_SunFlag $$
CREATE PROCEDURE V20221209184743__Create_SunFlag()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='flag')) THEN 
CREATE TABLE `flag` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `flagCode` VARCHAR(255) NOT NULL,
  `flagName` VARCHAR(100) NOT NULL,
  `flagStatus` BIT NOT NULL DEFAULT b'0',
  `flagCordinatorId` BIGINT NOT NULL,
  `businessRuleId` BIGINT NULL DEFAULT NULL,
  `startDate` DATE NULL DEFAULT NULL,
  `endDate` DATE NULL DEFAULT NULL,
  `isInitiated` BIT NOT NULL DEFAULT b'0',
  `approveStatus` BIT NOT NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) VISIBLE,
  UNIQUE INDEX `flagCode_UNIQUE` (`flagCode` ASC) INVISIBLE,
  INDEX `fk_flag_flagCordinatorId_idx_idx` (`flagCordinatorId` ASC) VISIBLE,
  INDEX `fk_flag_lastUpdatedBy_idx_idx` (`lastUpdatedBy` ASC) VISIBLE,
  CONSTRAINT `fk_flag_flagCordinatorId_idx`
    FOREIGN KEY (`flagCordinatorId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_flag_lastUpdatedBy_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20221209184743__Create_SunFlag () $$ 
DROP PROCEDURE IF EXISTS V20221209184743__Create_SunFlag $$ 
DELIMITER ;