DELIMITER $$
DROP PROCEDURE IF EXISTS V20221213192627__Create_Flag_Configuration_Detail $$
CREATE PROCEDURE V20221213192627__Create_Flag_Configuration_Detail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='flag_configuration_detail')) THEN 
CREATE TABLE flag_configuration_detail (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `flagId` BIGINT NOT NULL,
  `serialNumber` BIGINT NOT NULL,
  `fromScore` BIGINT NOT NULL,
  `tillScore` BIGINT NOT NULL,
  `notificationEventId` BIGINT DEFAULT NULL,
  `flagColorId` BIGINT NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_flag_configuration_detail_flagId_idx (flagId),
  KEY fk_flag_configuration_detail_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_flag_configuration_detail_flagId FOREIGN KEY (flagId) REFERENCES flag (id),
  CONSTRAINT fk_flag_configuration_detail_flagColorId FOREIGN KEY (flagColorId) REFERENCES flag_color (id),
  CONSTRAINT fk_flag_configuration_detail_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20221213192627__Create_Flag_Configuration_Detail () $$ 
DROP PROCEDURE IF EXISTS V20221213192627__Create_Flag_Configuration_Detail $$ 
DELIMITER ;