DELIMITER $$
DROP PROCEDURE IF EXISTS V20230210114107__Create_RoomTypeDefaultRadio_Main $$
CREATE PROCEDURE V20230210114107__Create_RoomTypeDefaultRadio_Main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_room_type_default_stage')) THEN 
CREATE TABLE `hostel_room_type_default_stage` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
    `hostelRoomTypeId` bigint null,
    `feePlanId` bigint null,
    `feePlanRuleId` bigint null,
    `feePlanStageId` bigint null,
    `feePlanRuleStageId` bigint null,
    `totalFeeHeadAmt` double(20,2) null,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
	FOREIGN KEY (`hostelRoomTypeId`) REFERENCES `hostel_room_type`(`id`),
	FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan`(`id`),
	FOREIGN KEY (`feePlanRuleId`) REFERENCES `fee_plan_rules`(`id`),
	FOREIGN KEY (`feePlanStageId`) REFERENCES `fee_stage_master`(`id`),
	FOREIGN KEY (`feePlanRuleStageId`) REFERENCES `fee_plan_rule_stage`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230210114107__Create_RoomTypeDefaultRadio_Main () $$ 
DROP PROCEDURE IF EXISTS V20230210114107__Create_RoomTypeDefaultRadio_Main $$ 
DELIMITER ;