DELIMITER $$
DROP PROCEDURE IF EXISTS V20230512143652__Update_ExternalExaminerDDataProvider $$
CREATE PROCEDURE V20230512143652__Update_ExternalExaminerDDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_EXAMINER_D_INFO')) THEN 
UPDATE dydt_data_line_item
SET whereClauseBindingDef = 'PRM_ADMISSION_ID', sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS external_examiner_d_first_name,
T4.middleName AS external_examiner_d_middle_name,
T4.lastName AS external_examiner_d_last_name,
T4.alternateEmailId AS external_examiner_d_alternative_email_id,
T4.emailId AS external_examiner_d_email_id,
T4.phoneNo AS external_examiner_d_telephone_no,
T4.mobileNumber AS external_examiner_d_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS external_examiner_d_address,
T13.code AS external_examiner_d_id,
T11.salutationName AS external_examiner_d_title,
T12.itemValue AS external_examiner_d_gender,
T14.itemValue AS external_examiner_d_nationality,
T15.employer AS external_examiner_d_employer_or_institution,
T15.department AS external_examiner_d_department,
T15.designation AS external_examiner_d_position_or_occupation,
T15.areaOfExpertise AS external_examiner_d_area_of_expertise_or_specialisation,
T7.faxNumber AS external_examiner_d_fax_no,
T4.highestQualification AS external_examiner_d_highest_qualification,
T4.awardingInstitution AS external_examiner_d_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS external_examiner_d_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS external_examiner_d_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS external_examiner_d_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS external_examiner_d_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS external_examiner_d_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS external_examiner_d_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS external_examiner_d_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS external_examiner_d_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.scopusGoogleProfileOfExternalExaminer AS external_examiner_d_scopus_or_google_profile,
T16.deviationFromNormalRequirements AS external_examiner_d_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS external_examiner_d_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS external_examiner_d_number_of_phds_examined,
T16.numberOfMastersExamined AS external_examiner_d_number_of_masters_examined
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='External Examiner D'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T4.id
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="external_examiner_d_first_name,external_examiner_d_middle_name,external_examiner_d_last_name,external_examiner_d_address,external_examiner_d_email_id,external_examiner_d_alternative_email_id,external_examiner_d_telephone_no,external_examiner_d_mobile_no,external_examiner_d_id,external_examiner_d_title,external_examiner_d_gender,external_examiner_d_nationality,external_examiner_d_employer_or_institution,external_examiner_d_department,external_examiner_d_position_or_occupation,external_examiner_d_area_of_expertise_or_specialisation,external_examiner_d_fax_no,external_examiner_d_highest_qualification,external_examiner_d_awarding_institution,external_examiner_d_number_of_phds_supervised_over_the_last_5_years,external_examiner_d_number_of_phds_completed,external_examiner_d_number_of_current_phds_students,external_examiner_d_number_of_masters_degrees_supervised_over_the_last_5_years,external_examiner_d_number_of_masters_degrees_completed,external_examiner_d_number_of_current_masters_students,external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals,external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,external_examiner_d_number_of_published_conference_papers,external_examiner_d_number_of_published_conference_papers_as_first_or_corresponding_author,external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations,external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,external_examiner_d_scopus_or_google_profile,external_examiner_d_motivate_deviation_from_normal_requirements,external_examiner_d_nomination_of_external_examiner,external_examiner_d_number_of_phds_examined,external_examiner_d_number_of_masters_examined",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='External Examiner D' order by T3.id desc limit 1;"
WHERE dataSourceCode = 'EXTERNAL_EXAMINER_D_INFO';

#------------------TRANSLATIONS---------------------

SET @dydtdatalinitemId = (SELECT id FROM dydt_data_line_item where dataSourceCode='EXTERNAL_EXAMINER_D_INFO');  
INSERT INTO dydt_templateparams_translations (translationCode, translationValue,dataProviderLineItemId) 
VALUES('external_examiner_d_employer_or_institution', 'External Examiner D Employer/Institution', @dydtdatalinitemId),
('external_examiner_d_department', 'External Examiner D Department', @dydtdatalinitemId),
('external_examiner_d_position_or_occupation', 'External Examiner D Position/Occupation',@dydtdatalinitemId),
('external_examiner_d_area_of_expertise_or_specialisation', 'External Examiner D Area of expertise/Specialisation',@dydtdatalinitemId),
('external_examiner_d_fax_no', 'External Examiner D Fax No.', @dydtdatalinitemId),
('external_examiner_d_highest_qualification', 'External Examiner D Highest qualification',@dydtdatalinitemId),
('external_examiner_d_awarding_institution', 'External Examiner D Awarding institution', @dydtdatalinitemId),
('external_examiner_d_number_of_phds_supervised_over_the_last_5_years', 'External Examiner D Number of PhDs supervised over the last 5 years', @dydtdatalinitemId),
('external_examiner_d_number_of_phds_completed', 'External Examiner D Number of PhDs completed', @dydtdatalinitemId),
('external_examiner_d_number_of_current_phds_students', 'External Examiner D Number of current PhD students', @dydtdatalinitemId),
('external_examiner_d_number_of_masters_degrees_supervised_over_the_last_5_years', 'External Examiner D Number of Masters degrees supervised over the last 5 years',@dydtdatalinitemId),
('external_examiner_d_number_of_masters_degrees_completed', 'External Examiner D Number of Masters degrees completed', @dydtdatalinitemId),
('external_examiner_d_number_of_current_masters_students', 'External Examiner D Number of current Masters students', @dydtdatalinitemId),
('external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals', 'External Examiner D Number of articles in peer-reviewed or refereed journals',@dydtdatalinitemId),
('external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author', 'External Examiner D Number of articles in peer-reviewed or refereed journals as first or corresponding author',@dydtdatalinitemId),
('external_examiner_d_number_of_published_conference_papers', 'External Examiner D Number of published conference papers', @dydtdatalinitemId),
('external_examiner_d_number_of_published_conference_papers_as_first_or_corresponding_author', 'External Examiner D Number of published conference papers as first or corresponding author',@dydtdatalinitemId),
('external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations', 'External Examiner D Number of Conferences and symposia Oral/Poster presentations',@dydtdatalinitemId),
('external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author', 'External Examiner D Number of Conferences and symposia Oral/Poster presentations as first or corresponding author',@dydtdatalinitemId),
('external_examiner_d_scopus_or_google_profile', 'External Examiner D Scopus/Google profile', @dydtdatalinitemId),
('external_examiner_d_motivate_deviation_from_normal_requirements', 'External Examiner D Motivate deviation from normal requirements', @dydtdatalinitemId),
('external_examiner_d_nomination_of_external_examiner', 'External Examiner D Nomination of External Examiner', @dydtdatalinitemId),
('external_examiner_d_number_of_phds_examined', 'External Examiner D Number of PhDs Examined', @dydtdatalinitemId),
('external_examiner_d_number_of_masters_examined', 'External Examiner D Number of Masters  Examined', @dydtdatalinitemId);

END IF; SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230512143652__Update_ExternalExaminerDDataProvider () $$
DROP PROCEDURE IF EXISTS V20230512143652__Update_ExternalExaminerDDataProvider $$
DELIMITER ;