DELIMITER $$
DROP PROCEDURE IF EXISTS V20230606133819__Update_LimeSurveyForFaculty $$
CREATE PROCEDURE V20230606133819__Update_LimeSurveyForFaculty()
BEGIN
	
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM msg_template_config WHERE code='LIME_SURVEY_FAC_TEMPLATE')) THEN 
	SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config WHERE code='LIME_SURVEY_FAC_TEMPLATE');
	SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
	UPDATE `msg_template_config` SET `msgMessageTypeId`=@msgMessageTypeId WHERE id=@msgtemplateconfigId;
	
	IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_FAC_RECIPIENTS')) THEN 
		SET @limeSurveyFac=(SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_FAC_RECIPIENTS');
		UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
		    T1.id AS ID,
		    T4.`salutationName` AS SALUTATION_NAME,
		    T3.`firstName` AS FIRST_NAME,
		    T3.`middleName` AS MIDDLE_NAME,
		    T3.`lastName` AS LAST_NAME,
		    T3.`emailId` AS EMAIL_ID,
		    T3.`mobileNumber` AS MOBILE_NO,
		    T1.`surveyUrl` AS SURVEY_URL,
		    T3.`mobileCountryCode` AS MOBILE_CODE,
		    ml.code as LANGUAGE_KEY,
		    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
		FROM
		    survey_participant_info T1
		        LEFT OUTER JOIN
		    staffs T2 ON T1.userId = T2.userId
		        LEFT OUTER JOIN
		    persons T3 ON T2.personId = T3.id
		        LEFT JOIN
		    salutations T4 ON T4.id = T3.salutationId
		        LEFT JOIN
			multi_language ml on ml.id=T3.correspondence_language
				LEFT JOIN
		    `fire_base_persons_info` f ON f.userId = T2.userId
		WHERE
		    T1.id IN (namedParams)" WHERE `dataProviderId`=@limeSurveyFac;
	END If;
		    
	IF NOT EXISTS ((SELECT * FROM `msg_template` WHERE `msgTemplateConfigId`=@msgtemplateconfigId AND `msgDeliveryModeId`=6)) THEN 
		SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
		INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
		VALUES (@msgtemplateId+1,@msgtemplateconfigId,'6','Survey Invitation','Hello $recipientData["SALUTATION_NAME"] $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], Please provide your feedback for this survey $recipientData["SURVEY_URL"] Thank you');
	END IF;	
END IF; 
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20230606133819__Update_LimeSurveyForFaculty () $$
DROP PROCEDURE IF EXISTS V20230606133819__Update_LimeSurveyForFaculty $$
DELIMITER ;