DELIMITER $$
DROP PROCEDURE IF EXISTS V20230623195018__Create_ApplicantPassportDetail $$
CREATE PROCEDURE V20230623195018__Create_ApplicantPassportDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_passport_detail')) THEN 
CREATE TABLE `applicant_passport_detail`(
`id` bigint NOT NULL AUTO_INCREMENT,
`applicantPersonId` bigint(20) NOT NULL,
`countryOfIssue` bigint(20) DEFAULT NULL,
`passportNumber` varchar(30) NOT NULL,
`fileModifiedDate` date DEFAULT NULL,
`passportExpirationDate` date DEFAULT NULL,
`isPrimary` boolean DEFAULT FALSE,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_ApplicantPassportDetail_SU_person` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
CONSTRAINT `FK_ApplicantPassportDetail_SU_countryOfIssue` FOREIGN KEY (`countryOfIssue`) REFERENCES `country` (`id`),
CONSTRAINT `FK_ApplicantPassportDetail_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20230623195018__Create_ApplicantPassportDetail () $$ 
DROP PROCEDURE IF EXISTS V20230623195018__Create_ApplicantPassportDetail $$ 
DELIMITER ;