DELIMITER $$
DROP PROCEDURE IF EXISTS V20230623200441__Create_ApplicantDetailsDocument $$
CREATE PROCEDURE V20230623200441__Create_ApplicantDetailsDocument()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_detail_document')) THEN 
CREATE TABLE `applicant_detail_document`(  
  `id`BIGINT(20) NOT NULL AUTO_INCREMENT,
  `applicantPassportDetailId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `applicant_passport_detail_document_FK` FOREIGN KEY (`applicantPassportDetailId`) REFERENCES applicant_passport_detail(`id`),
  CONSTRAINT `applicant_passport_detail_document_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `applicant_passport_detail_document_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF;

END $$
CALL V20230623200441__Create_ApplicantDetailsDocument () $$ 
DROP PROCEDURE IF EXISTS V20230623200441__Create_ApplicantDetailsDocument $$ 
DELIMITER ;