DELIMITER $$
DROP PROCEDURE IF EXISTS V20230725104730__Create_StudentHealthDocument $$
CREATE PROCEDURE V20230725104730__Create_StudentHealthDocument()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_document')) THEN 
CREATE TABLE `student_health_document`(  
  `id`BIGINT(20) NOT NULL AUTO_INCREMENT,
  `healthId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `student_health_document_FK` FOREIGN KEY (`healthId`) REFERENCES student_health_details(`id`),
  CONSTRAINT `student_health_document_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `student_health_document_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`))
  ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230725104730__Create_StudentHealthDocument () $$ 
DROP PROCEDURE IF EXISTS V20230725104730__Create_StudentHealthDocument $$ 
DELIMITER ;