DELIMITER $$
DROP PROCEDURE IF EXISTS V20230725123530__Create_ApplicantInsuranceDetail $$
CREATE PROCEDURE V20230725123530__Create_ApplicantInsuranceDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_insurance_detail')) THEN 
CREATE TABLE `applicant_insurance_detail`(
`id` bigint NOT NULL AUTO_INCREMENT,
`applicantPersonId` bigint(20) NOT NULL,
`healthInsuranceConfirmed` bit(1) DEFAULT NULL,
`schoolInsuranceType` bigint DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_ApplicantInsuranceDetail_SU_person` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
CONSTRAINT `FK_ApplicantInsuranceDetail_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_ApplicantInsuranceDetail_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
CONSTRAINT `FK_ApplicantInsuranceDetail_visaType_FK` FOREIGN KEY (`schoolInsuranceType`) REFERENCES `drop_down`(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20230725123530__Create_ApplicantInsuranceDetail () $$ 
DROP PROCEDURE IF EXISTS V20230725123530__Create_ApplicantInsuranceDetail $$ 
DELIMITER ;