DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726133256__Create_PermitDetailDocumentTable $$
CREATE PROCEDURE V20230726133256__Create_PermitDetailDocumentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='permit_detail_document')) THEN 
CREATE TABLE `permit_detail_document` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `permitDetailId` BIGINT(20) NOT NULL,
    `documentId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    CONSTRAINT `fk_permit_detail_document_permitDetailId` FOREIGN KEY (`permitDetailId`) REFERENCES `permit_detail`(`id`),
    CONSTRAINT `fk_permit_detail_document_documentId` FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`),
    CONSTRAINT `fk_permit_detail_document_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230726133256__Create_PermitDetailDocumentTable () $$ 
DROP PROCEDURE IF EXISTS V20230726133256__Create_PermitDetailDocumentTable $$ 
DELIMITER ;