DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726141553__Create_StudentEducationDetail $$
CREATE PROCEDURE V20230726141553__Create_StudentEducationDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_education_detail')) THEN 
CREATE TABLE `student_education_detail`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint(20) NOT NULL,
`nameOfInstitutionsAttended` varchar(255) NOT NULL,
`highestQualification` varchar(255) NOT NULL,
`graduationDate` date DEFAULT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_studentEducationHistoryDetail_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_studentEducationHistoryDetail_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20230726141553__Create_StudentEducationDetail () $$ 
DROP PROCEDURE IF EXISTS V20230726141553__Create_StudentEducationDetail $$ 
DELIMITER ;