DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726185703__Create_ProgressionStatusTable $$
CREATE PROCEDURE V20230726185703__Create_ProgressionStatusTable()
BEGIN

       IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='progression_status')) THEN 
		
		CREATE TABLE `progression_status`( 
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
		`itemCode` varchar(100) NOT NULL,
		`itemValue` varchar(100) NOT NULL,	
		`progressionStatus` VARCHAR(20) NOT NULL,
		`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		`lastUpdatedBy` BIGINT(20),
		PRIMARY KEY (`id`), 
		UNIQUE `progression_status_UNIQUE`(itemCode),
		CONSTRAINT `progression_status_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
		ENGINE=INNODB DEFAULT  CHARSET=utf8; 
	
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master where tableName='admission_condition' AND masterName='PROGRESSION_STATUS')) THEN
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
	INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@standardMasterMaxId+1,'progression_status', 'PROGRESSION_STATUS', 'Program & Courses', 'COMMON_MASTER', 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@ItemsMaxId + 1,'code', 'ITEM_CODE', @standardMasterMaxId+1 , 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId + 1,'value', 'ITEM_NAME', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId + 1, 'progressionStatus', 'PROGRESSION_STATUS', @standardMasterMaxId+1, 'Enum', 'PROGRESSION_STATUS', '3', false, 0, 0,0, '1', SYSDATE());
	END IF;

	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'PROGRESSION_STATUS')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('masterNames', 'PROGRESSION_STATUS', 'Progression Status', 'Progression Status','Progressie Status','Tình trạng tiến triển',now(),1);
	END IF;
    
END $$
CALL V20230726185703__Create_ProgressionStatusTable () $$ 
DROP PROCEDURE IF EXISTS V20230726185703__Create_ProgressionStatusTable $$ 
DELIMITER ;