DELIMITER $$
DROP PROCEDURE IF EXISTS V20230728143945__Create_ApplicantHealthDetails $$
CREATE PROCEDURE V20230728143945__Create_ApplicantHealthDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_health_details')) THEN 
CREATE TABLE IF NOT EXISTS `applicant_health_details` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`personId` bigint DEFAULT NULL,	
	`medicalConditionOther` VARCHAR(255) DEFAULT NULL,	
    `medicationOther` VARCHAR(255) DEFAULT NULL,	
    `allergiesOther` VARCHAR(255) DEFAULT NULL,	
    `learningDifficultiesOther` VARCHAR(255) DEFAULT NULL,
	`auditId` bigint NOT NULL,	
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`),
CONSTRAINT `FK_ApplicantHealthDetails_SU_person` FOREIGN KEY (`personId`) REFERENCES `applicant_person` (`id`),
CONSTRAINT `FK_ApplicantHealthDetails_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_ApplicantHealthDetails_SU_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230728143945__Create_ApplicantHealthDetails () $$ 
DROP PROCEDURE IF EXISTS V20230728143945__Create_ApplicantHealthDetails $$ 
DELIMITER ;