DELIMITER $$
DROP PROCEDURE IF EXISTS V20230731132908__Insert_ApplicantEducationHistoryDataGrid $$
CREATE PROCEDURE V20230731132908__Insert_ApplicantEducationHistoryDataGrid()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.personalinfo.ApplicantEducationDetailsGrid'  and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.personinfo.common.personalinfo.ApplicantEducationDetailsGrid',1,
'[{"id":null,"columnName":"NAME_OF_INSTITUTIONS_ATTENDED","dataIndex":"nameOfInstitutionsAttended","columnVisibility":"SHOW","sequence":1,"mandatory":true},
  {"id":null,"columnName":"HIGHEST_QUALIFICATION","dataIndex":"highestQualification","columnVisibility":"SHOW","sequence":2,"mandatory":false},
  {"id":null,"columnName":"GRADUATION_DATE","dataIndex":"graduationDate","columnVisibility":"SHOW","sequence":3,"mandatory":false},
  {"id":null,"columnName":"GRADUATION_DOCUMENT","dataIndex":"graduationDocument","columnVisibility":"SHOW","sequence":4,"mandatory":false},
  {"id":null,"columnName":"GRADUATION_DOCUMENT_URL","dataIndex":"graduationDocumentUrl","columnVisibility":"SHOW","sequence":5,"mandatory":false}]'
  ,now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'STUDENT_EDUCATION_DETAILS_ADD_SUCCESS' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','STUDENT_EDUCATION_DETAILS_ADD_SUCCESS',"Education Details Record Add Successfully","Education Details Record Add Successfully",
"Onderwysbesonderhede Rekord Voeg suksesvol by","Bản ghi chi tiết giáo dục Thêm thành công",now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'STUDENT_EDUCATION_DETAILS_UPDATE_SUCCESS' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','STUDENT_EDUCATION_DETAILS_UPDATE_SUCCESS',"Education Details Record Update Successfully","Education Details Record Update Successfully",
"Onderwysbesonderhede Rekordopdatering suksesvol","Cập nhật hồ sơ chi tiết giáo dục thành công",now(),1);
END IF;	    

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'DELETE_EDUCATION_DETAILS' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','DELETE_EDUCATION_DETAILS',"Delete Education Details","Delete Education Details","Vee onderwysbesonderhede uit","Xóa chi tiết giáo dục",now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'EDUCATION_DETAILS_DELETE_SUCCESS' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','EDUCATION_DETAILS_DELETE_SUCCESS',"Education Details Deleted Successfully","Education Details Deleted Successfully",
"Onderwysbesonderhede is suksesvol uitgevee","Đã xóa chi tiết giáo dục thành công",now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName = 'APPLICANT_EDUCATION_DETAILS' and  objectName ='TRANSLATIONS')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS','APPLICANT_EDUCATION_DETAILS',"Applicant Education Details","Applicant Education Details","Aansoeker Onderwys Besonderhede","Chi tiết giáo dục của người nộp đơn",now(),1);
END IF;

END $$
CALL V20230731132908__Insert_ApplicantEducationHistoryDataGrid() $$
DROP PROCEDURE IF EXISTS V20230731132908__Insert_ApplicantEducationHistoryDataGrid $$
DELIMITER ;