DELIMITER $$
DROP PROCEDURE IF EXISTS V20230731162205__Update_OutstandingBillReminderDLRecipient $$
CREATE PROCEDURE V20230731162205__Update_OutstandingBillReminderDLRecipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE bh.raiseBillCategory!='BILL_PAYABLE' and
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>" WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    (select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
    LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.raiseBillCategory!='BILL_PAYABLE' and bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id
" WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_S2_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_S2_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE bh.raiseBillCategory!='BILL_PAYABLE' and
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0" WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_S2_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STU_REM_ON_DAY_S2_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    (select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
		LEFT JOIN
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.raiseBillCategory!='BILL_PAYABLE' and bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0" WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    REPLACE(FORMAT(SUM(bfprs.balanceAmount),2),',',"" ) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
     bh.raiseBillCategory!='BILL_PAYABLE' and bh.id IN (namedParams) 
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'FATHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.raiseBillCategory!='BILL_PAYABLE' and  bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'FATHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    REPLACE(FORMAT(SUM(bfprs.balanceAmount),2),',',"" ) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    REPLACE(FORMAT(SUM(bfprs.balanceAmount),2),',',"" ) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S1_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S1_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S1_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S1_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
    LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
     bh.raiseBillCategory!='BILL_PAYABLE' and  bh.id IN (namedParams) 
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S2_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S2_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S2_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_DAY_S2_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			)
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    (select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
          (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			)
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
            (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			)
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    REPLACE(FORMAT(SUM(bfprs.balanceAmount),2),',',"" ) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
            (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , '%Y-%m-%d')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , '%Y-%m-%d')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , '%Y-%m-%d'))
			) 
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
   	 	LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_STUDENT_REM_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    (select GROUP_CONCAT(DISTINCT deviceTokenId) from fire_base_persons_info where fire_base_persons_info.userId=bh.studentId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate < DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FATHER_REM_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    REPLACE(FORMAT(SUM(bfprs.balanceAmount),2),',',"" ) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'FATHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate < DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_MOTHER_REM_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    REPLACE(FORMAT(SUM(bfprs.balanceAmount),2),',',"" ) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_DL')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_DL');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
           bh.dueDate = DATE_FORMAT(DATE(NOW()), '%Y-%m-%d')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
               AND u.status<>0 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_RCPNT')) THEN 
SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE dataProviderName='OUTSTANDING_BILL_FP_REM_RCPNT');

UPDATE sql_dtprovider SET sqlQuery=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1 " WHERE dataProviderId=@studentReminderOnDueDay;
END IF; 



SET SQL_SAFE_UPDATES=1;

END $$
CALL V20230731162205__Update_OutstandingBillReminderDLRecipient () $$
DROP PROCEDURE IF EXISTS V20230731162205__Update_OutstandingBillReminderDLRecipient $$
DELIMITER ;