DELIMITER $$
DROP PROCEDURE IF EXISTS V20230801113114__Create_AppPermitDetailDocTable $$
CREATE PROCEDURE V20230801113114__Create_AppPermitDetailDocTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_permit_detail_document')) THEN 
CREATE TABLE `applicant_permit_detail_document` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `applicantPermitDetailId` BIGINT(20) NOT NULL,
    `documentId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    CONSTRAINT `fk_applicant_permit_detail_document_applicantPermitDetailId` FOREIGN KEY (`applicantPermitDetailId`) REFERENCES `applicant_permit_detail`(`id`),
    CONSTRAINT `fk_applicant_permit_detail_document_documentId` FOREIGN KEY (`documentId`) REFERENCES `documents`(`id`),
    CONSTRAINT `fk_applicant_permit_detail_document_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230801113114__Create_AppPermitDetailDocTable () $$ 
DROP PROCEDURE IF EXISTS V20230801113114__Create_AppPermitDetailDocTable $$ 
DELIMITER ;