DELIMITER $$
DROP PROCEDURE IF EXISTS V20230824185553__Create_NewProgramBatchPeriodActivityDate $$
CREATE PROCEDURE V20230824185553__Create_NewProgramBatchPeriodActivityDate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='period_activity_date_details')) THEN

CREATE TABLE `period_activity_date_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `periodEventId` BIGINT(20) NOT NULL,
  `programBatchPeriodConfigurationId` BIGINT(20) NOT NULL,
  `startDate` TIMESTAMP NULL DEFAULT NULL,
  `endDate` TIMESTAMP NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_applicant_person_interventions_idx` (`periodEventId` ASC),
  INDEX `fk_applicant_person_Id_idx` (`programBatchPeriodConfigurationId` ASC),
  INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_period_activity_date_details_id`
    FOREIGN KEY (`periodEventId`)
    REFERENCES `period_event_name_csm` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_period_activity_date_details_programbatchperiodid`
    FOREIGN KEY (`programBatchPeriodConfigurationId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_period_activity_date_details_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF;  

END $$
CALL V20230824185553__Create_NewProgramBatchPeriodActivityDate () $$ 
DROP PROCEDURE IF EXISTS V20230824185553__Create_NewProgramBatchPeriodActivityDate $$ 
DELIMITER ;