DELIMITER $$
DROP PROCEDURE IF EXISTS V20230912125919__Create_CommitteeRaiseRequest $$
CREATE PROCEDURE V20230912125919__Create_CommitteeRaiseRequest()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='committee_raise_request')) THEN 
CREATE TABLE IF NOT EXISTS  `committee_raise_request`(
`id` bigint NOT NULL AUTO_INCREMENT,
`studentId` bigint(20) NOT NULL,
`requesterName` varchar(50) NOT NULL,
`intakeList` varchar(500) NULL,
`programList` varchar(500) NULL,
`seatTypeList` varchar(500) NULL,
`email` varchar(50) NULL,
`mobileNo` varchar(15) NULL,
`enteredBy` bigint(20) NOT NULL,
`requestAssignTo` bigint(20) NULL,
`requestDate` date NOT NULL,
`committeeId` bigint(20) NOT NULL,
`membershipTypeId` bigint(20) NOT NULL,
`membershipAmount` double(20,2),
`description` varchar(500),
`approvalStatus` varchar(20) null,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_CommitteeRaiseRequest_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
CONSTRAINT `FK_CommitteeRaiseRequest_FK_studentId` FOREIGN KEY (`studentId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_CommitteeRaiseRequest_enteredBy_FK` FOREIGN KEY (`enteredBy`) REFERENCES `users`(`id`),
CONSTRAINT `FK_CommitteeRaiseRequest_committee_FK` FOREIGN KEY (`committeeId`) REFERENCES `committee`(`id`),
CONSTRAINT `FK_CommitteeRaiseRequest_membershipTypeId_FK` FOREIGN KEY (`membershipTypeId`) REFERENCES `membership_type`(`id`),
CONSTRAINT `FK_CommitteeRaiseRequest_requestAssignTo_FK` FOREIGN KEY (`requestAssignTo`) REFERENCES `users`(`id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 
IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='committee_raise_request') THEN
ALTER TABLE committee_raise_request AUTO_INCREMENT=100;
END IF;
END $$
CALL V20230912125919__Create_CommitteeRaiseRequest () $$ 
DROP PROCEDURE IF EXISTS V20230912125919__Create_CommitteeRaiseRequest $$ 
DELIMITER ;