DELIMITER $$
DROP PROCEDURE IF EXISTS V20230926165834__Create_SmtpOauth2ConfigTable $$
CREATE PROCEDURE V20230926165834__Create_SmtpOauth2ConfigTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='smtp_oauth_two_configuration')) THEN 
	
	CREATE TABLE `smtp_oauth_two_configuration`( 
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
		`academyLocationId` BIGINT(20) NOT NULL,
		`clientId` varchar(255) NOT NULL,	
		`clientSecret` VARCHAR(255) NOT NULL,
		`tenantId` VARCHAR(255) NOT NULL,
		`displayEmailId` VARCHAR(255) NOT NULL,
		`isActive` BIT(1) NOT NULL DEFAULT false,
		`isDefault` BIT(1) NOT NULL DEFAULT false,
		`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
		`lastUpdatedBy` BIGINT(20) NOT NULL,
		PRIMARY KEY (`id`), 
		CONSTRAINT `smtp_oauth_two_config_academyLocationId_FK` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`),
		CONSTRAINT `smtp_oauth_two_config_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
	ENGINE=INNODB DEFAULT  CHARSET=utf8;
	
	IF NOT EXISTS ((SELECT * FROM standard_master where tableName='smtp_oauth_two_configuration' AND masterName='SMTP_OAUTH_TWO_CONFIGURATION')) THEN
		
		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@standardMasterMaxId+1,'smtp_oauth_two_configuration', 'SMTP_OAUTH_TWO_CONFIGURATION', 'MASTER_WITH_AL', 0, 0, '1', SYSDATE());

		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,
		`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1, 'academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId+1, 'Varchar', '1', 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, '1', SYSDATE());
		 
 		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
 		VALUES (@ItemsMaxId + 1,'clientId', 'CLIENT_ID', @standardMasterMaxId+1 , 'Varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

 		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1,'clientSecret', 'CLIENT_SECRET', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 0, '1', SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1,'tenantId', 'TENANT_ID', @standardMasterMaxId+1, 'Varchar', '4', 0, 0, 0, 0, '1', SYSDATE());
	
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1,'isActive', 'ACTIVE', @standardMasterMaxId+1, 'Boolean', '5', 0, 0, 0, 0, '1', SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1,'isDefault', 'DEFAULT', @standardMasterMaxId+1, 'Boolean', '6', 0, 0, 0, 0, '1', SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `validationType`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1,'displayEmailId', 'DISPLAY_EMAIL_ID', @standardMasterMaxId+1, 'Varchar', '7', 0, 0, 0, 0, 'email', '1', SYSDATE());
		
	END IF;
	
END IF; 

END $$
CALL V20230926165834__Create_SmtpOauth2ConfigTable () $$ 
DROP PROCEDURE IF EXISTS V20230926165834__Create_SmtpOauth2ConfigTable $$ 
DELIMITER ;