DELIMITER $$
DROP PROCEDURE IF EXISTS V20231004184628__Create_ApplicationOwnerEvent $$
CREATE PROCEDURE V20231004184628__Create_ApplicationOwnerEvent()
BEGIN

 IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='APPLICATION_FORM_SUBMISISON_OWNER')) THEN
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'APPLICATION_FORM_SUBMISISON_OWNER');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPLICATION_FORM_SUBMISISON_OWNER');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_FORM_SUBMISISON_OWNER', 'Application Form Submission Owner', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application Form Submission Owner');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_FORM_SUBMISISON_OWNER_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_FORM_SUBMISISON_OWNER_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FORM_SUBMISISON_OWNER_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_FORM_SUBMISISON_OWNER_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FORM_SUBMISISON_OWNER_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_FORM_SUBMISISON_OWNER_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FORM_SUBMISISON_OWNER_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM application T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FORM_SUBMISISON_OWNER_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT
	T1.`id` AS ID,    
    T2.`printName` AS APPLICATION_FULL_NAME,
    T1.`code` AS APPLICATION_ID,
    T3.emailId AS EMAIL_ID,
    T3.firstName AS FIRST_NAME,
    T3.middleName AS MIDDLE_NAME,
    T3.lastName AS LAST_NAME,
    T5.mobileNumber AS MOBILE_NO,
    T3.code AS DEFAULT_OWNER_USER_CODE
  FROM
    application T1
    LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
    LEFT JOIN
    users T3 on T1.applicationOwner = T3.id
    LEFT JOIN
    staffs T4 on T3.id = T4.userId
    LEFT JOIN
    persons T5 on T4.personId = T5.id
	WHERE
    T1.id IN (namedParams)limit 1",'{
     "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "APPLICATION_FULL_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 1
        },
		 {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		 {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "code",
            "resultKey": "DEFAULT_OWNER_USER_CODE",
            "displayCode": "",
            "displayOrder": 5
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='APPLICATION_FORM_SUBMISISON_OWNER_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T3.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_FORM_SUBMISISON_OWNER');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPLICATION_FORM_SUBMISISON_OWNER');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_FORM_SUBMISISON_OWNER_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Application Form Submission Owner',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application Form Submission Owner',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Form Submission Owner','<html>
 <head>
 	<title></title>
 </head>
 <body style="font-family:sans-serif, Arial, Helvetica; font-size:12px">
 <div style="display: none;">&nbsp;</div>
 
 <table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
 	<tbody>
 		<tr style="background-color:#f0f0f0; line-height:20px;">
 			<td style="padding:20px 20px 20px 20px;">
            <p>Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;],</p>
            <p>Please note that the following application has been generated from the Online Application form and has been assigned to you as the owner:</p>
            <p>$recipientData[&quot;APPLICATION_ID&quot;] / $recipientData[&quot;APPLICATION_FULL_NAME&quot;]</p>
 			
 			</td>
 		</tr>	
 	</tbody>
 </table>
 </body>
 </html>');
 
  INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Dear $recipientData[&quot;FIRST_NAME&quot;] & $recipientData[&quot;LAST_NAME&quot;]','Please note that the following application has been generated from the Online Application form and has been assigned to you as the owner: $recipientData[&quot;APPLICATION_ID&quot;] / $recipientData[&quot;APPLICATION_FULL_NAME&quot;]');
 
 
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Please note that the following application has been generated from the Online Application form and has been assigned to you as the owner: $recipientData[&quot;APPLICATION_ID&quot;] / $recipientData[&quot;APPLICATION_FULL_NAME&quot;]');

END IF; 

END $$
CALL V20231004184628__Create_ApplicationOwnerEvent () $$ 
DROP PROCEDURE IF EXISTS V20231004184628__Create_ApplicationOwnerEvent $$ 
DELIMITER ;