DELIMITER $$
DROP PROCEDURE IF EXISTS V20231030142614__Update_FeePayerIdDP $$
CREATE PROCEDURE V20231030142614__Update_FeePayerIdDP()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='FEE_PAYER_ID')) THEN 
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = "select CASE WHEN fd.feePayerID IS NULL THEN 'Not Submitted' ELSE 'Submitted' END AS FEE_PAYER_ID,
    CASE WHEN fd.feePayerProofOfAccount IS NULL THEN 'Not Submitted' ELSE 'Submitted' END AS PROOF_OF_ACCOUNT
        from 
        fee_payer_detail fd 
    	left outer join 
        students st on st.personId = fd.personId
    	left outer join
        admission a on a.studentId = st.userId",
    `resultColumnsDef` = "FEE_PAYER_ID,PROOF_OF_ACCOUNT"
WHERE dataSourceCode='FEE_PAYER_ID';
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item` where dataSourceCode="FEE_PAYER_ID");
IF NOT EXISTS ((SELECT * FROM `dydt_templateparams_translations` where translationCode='PROOF_OF_ACCOUNT')) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('PROOF_OF_ACCOUNT', 'Proof Of Account',@dydtdatalinitemId);
END IF; 
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20231030142614__Update_FeePayerIdDP () $$
DROP PROCEDURE IF EXISTS V20231030142614__Update_FeePayerIdDP $$
DELIMITER ;