DELIMITER $$
DROP PROCEDURE IF EXISTS V20240220152330__Create_Cost_CentreChildCSM_Transaction $$
CREATE PROCEDURE V20240220152330__Create_Cost_CentreChildCSM_Transaction()
BEGIN
IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='cost_centre_child_transaction'))) THEN 
	CREATE TABLE `cost_centre_child_transaction` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`costCentreChildTransactionId` BIGINT(20) NULL,
  		`itemCode` varchar(255) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
		INDEX `fk_cost_centre_child_transaction_id_idx` (`costCentreChildTransactionId` ASC),
		INDEX `fk_cost_centre_child_transaction_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
	  	CONSTRAINT `fk_cost_centre_child_transaction_id_idx`
		    FOREIGN KEY (`costCentreChildTransactionId`)
		    REFERENCES `cost_centre` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_cost_centre_child_transaction_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ;

	END IF; 
    IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'cost_centre_child_transaction')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'cost_centre_child_transaction','COST_CENTRE_CHILD_TRANSACTION','Fees & Payments','COMMON_MASTER',1,0,1,SYSDATE());
		
		
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='cost_centre_child_transaction');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='cost_centre';
		SET SQL_SAFE_UPDATES = 1;
		
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'code', 'Transaction ID', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		


END IF; 


END $$
CALL V20240220152330__Create_Cost_CentreChildCSM_Transaction () $$ 
DROP PROCEDURE IF EXISTS V20240220152330__Create_Cost_CentreChildCSM_Transaction $$ 
DELIMITER ;