DELIMITER $$
DROP PROCEDURE IF EXISTS V20240221104922__Create_blackboardUserMapping $$
CREATE PROCEDURE V20240221104922__Create_blackboardUserMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='blackboard_user_mapping')) THEN 
CREATE TABLE blackboard_user_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    blackboardUserId VARCHAR(255),
    academiaUserId bigint NOT NULL,
    externalId VARCHAR(255),
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_blackboard_user_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_blackboard_user_mapping_academiaUserId_idx (academiaUserId),
  CONSTRAINT fk_blackboard_user_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_blackboard_user_mapping_academiaUserId FOREIGN KEY (academiaUserId) REFERENCES users (id)

) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240221104922__Create_blackboardUserMapping () $$ 
DROP PROCEDURE IF EXISTS V20240221104922__Create_blackboardUserMapping $$ 
DELIMITER ;