DELIMITER $$
DROP PROCEDURE IF EXISTS V20240222130518__Create_googleCalIntegration $$
CREATE PROCEDURE V20240222130518__Create_googleCalIntegration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='google_calendar_integration')) THEN 
CREATE TABLE `google_calendar_integration`
(
 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
 `googleCalendarRedirectUrl` TEXT NOT NULL,
 `googleCalendarPortNo` BIGINT(20) DEFAULT 0,
 `googleCalendarClientId`  TEXT NOT NULL,
 `googleCalendarClientSecret` TEXT NOT NULL,
 `googleCalendarRefToken` TEXT DEFAULT NULL,
 `googleCalendarAccessToken` TEXT DEFAULT NULL,
 `googleCalendarExpiryTime`  BIGINT(20) DEFAULT 0,
 `googleCalendarMicrServiceStatus` TEXT DEFAULT NULL,
 `lastUpdatedBy` BIGINT(20) NOT NULL,
 `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
    UNIQUE KEY googleCalendarRedirectUrl_UNIQUE (googleCalendarRedirectUrl(255)),
    KEY fk_google_calendar_integration_lastUpdatedBy_idx (lastUpdatedBy),
    CONSTRAINT fk_google_calendar_integration_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
   ) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO standard_master(`tableName`, `masterName`,`moduleName`,`filterCode`,`whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES ('google_calendar_integration', 'GOOGLE_CALENDAR_INTEGRATION', 'Google Calendar Setup','MASTER_WITH_AL',0, 0, '1', SYSDATE());
 
 SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items
(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `emunType`,`diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,
`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('googleCalendarRedirectUrl', 'GOOGLE_CALENDAR_REDIRECT_URL', @standardMasterMaxId, 'Varchar', NULL,'1', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('googleCalendarPortNo', 'GOOGLE_CALENDAR_PORT_NO', @standardMasterMaxId, 'Number', NULL,'2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('googleCalendarClientId', 'GOOGLE_CALENDAR_CLIENT_ID', @standardMasterMaxId, 'Varchar', NULL,'3', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('googleCalendarClientSecret', 'GOOGLE_CALENDAR_CLIENT_SECRET', @standardMasterMaxId, 'Varchar', NULL,'4', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('googleCalendarRefToken','GOOGLE_CALENDAR_REFTOKEN',@standardMasterMaxId,'Varchar',NULL,'5',0,NULL,NULL,NULL,0,1,1,'1',SYSDATE()),
('googleCalendarAccessToken','GOOGLE_CALENDAR_ACCESS_TOKEN',@standardMasterMaxId,'Varchar',NULL,'6',0,NULL,NULL,NULL,0,1,1,'1',SYSDATE()),
('googleCalendarExpiryTime','GOOGLE_CALENDAR_EXPIRETIME',@standardMasterMaxId,'Number',NULL,'7',0,NULL,NULL,NULL,0,1,1,'1',SYSDATE()),
('googleCalendarMicrServiceStatus','GOOGLE_CALENDAR_MICROSERVICE_STATUS',@standardMasterMaxId,'Varchar',NULL,'8',0,NULL,NULL,NULL,0,1,1,'1',SYSDATE());

END IF; 

END $$
CALL V20240222130518__Create_googleCalIntegration () $$ 
DROP PROCEDURE IF EXISTS V20240222130518__Create_googleCalIntegration $$ 
DELIMITER ;