DELIMITER $$
DROP PROCEDURE IF EXISTS V20240226125747__Create_blackboardCourseMapping $$
CREATE PROCEDURE V20240226125747__Create_blackboardCourseMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='blackboard_course_mapping')) THEN 
CREATE TABLE blackboard_course_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    blackboardCourseId VARCHAR(255),
    academiaCourseVariantId bigint NOT NULL,
    externalId VARCHAR(255),
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_blackboard_course_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_blackboard_course_mapping_academiaCourseVariantId_idx (academiaCourseVariantId),
  CONSTRAINT fk_blackboard_course_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_blackboard_course_mapping_academiaCourseVariantId FOREIGN KEY (academiaCourseVariantId) REFERENCES course_variants (id)

) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240226125747__Create_blackboardCourseMapping () $$ 
DROP PROCEDURE IF EXISTS V20240226125747__Create_blackboardCourseMapping $$ 
DELIMITER ;