DELIMITER $$
DROP PROCEDURE IF EXISTS V20240228153430__Create_SendSOAReportTable $$
CREATE PROCEDURE V20240228153430__Create_SendSOAReportTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='send_statement_of_account_report')) THEN 
CREATE TABLE `send_statement_of_account_report`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`studentId` BIGINT(20) NOT NULL,
	`statementFrom` DATE NOT NULL,
	`statementTo` DATE NOT NULL,
	`currentMonth` VARCHAR(12) NOT NULL,
	`documentPath` VARCHAR(255) NULL,
	`status` VARCHAR(10) NOT NULL,
	`failureReason` VARCHAR(255) NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`), 
	CONSTRAINT `send_statement_of_account_report_studentId_FK` FOREIGN KEY (`studentId`) REFERENCES `users`(`id`),
	CONSTRAINT `send_statement_of_account_report_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=INNODB; 
END IF;

END $$
CALL V20240228153430__Create_SendSOAReportTable () $$ 
DROP PROCEDURE IF EXISTS V20240228153430__Create_SendSOAReportTable $$ 
DELIMITER ;