DELIMITER $$
DROP PROCEDURE IF EXISTS V20240320185547__Alter_scholarship_accounting_poet_based $$
CREATE PROCEDURE V20240320185547__Alter_scholarship_accounting_poet_based()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='scholarship_accounting_costcentre_poet_details' AND column_name='poetMasterDetailId')) THEN 
ALTER TABLE `scholarship_accounting_costcentre_poet_details` 
ADD COLUMN `poetMasterDetailId`  BIGINT DEFAULT NULL AFTER `costCentreAmount`,
ADD COLUMN `poetMasterTaskDetailId`  BIGINT DEFAULT NULL AFTER `poetMasterDetailId`,
ADD COLUMN `poetMasterContractDetailId`  BIGINT DEFAULT NULL AFTER `poetMasterTaskDetailId`,
ADD COLUMN `poetMasterContractFundSourceId`  BIGINT DEFAULT NULL AFTER `poetMasterContractDetailId`,
ADD COLUMN `expenditureTypeId`  BIGINT DEFAULT NULL AFTER `poetMasterContractFundSourceId`,
ADD COLUMN `expenditureOrganizationId`  BIGINT DEFAULT NULL AFTER `expenditureTypeId`;

ALTER TABLE `scholarship_accounting_costcentre_poet_details`
ADD CONSTRAINT `fk_sch_acc_cc_poetDetails_poetMasterDetailId`
FOREIGN KEY (`poetMasterDetailId`)
REFERENCES `poet_master_details` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_sch_acc_cc_poetDetails_poetMasterTaskDetailId`
FOREIGN KEY (`poetMasterTaskDetailId`)
REFERENCES `poet_master_task_details` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_sch_acc_cc_poetDetails_poetMasterContractDetailId`
FOREIGN KEY (`poetMasterContractDetailId`)
REFERENCES `poet_master_contract_details` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_sch_acc_cc_poetDetails_poetMasterContractFundSourceId`
FOREIGN KEY (`poetMasterContractFundSourceId`)
REFERENCES `poet_master_contract_fund_source` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_sch_acc_cc_poetDetails_expenditureTypeId`
FOREIGN KEY (`expenditureTypeId`)
REFERENCES `expenditure_type_csm` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_sch_acc_cc_poetDetails_expenditureOrganizationId`
FOREIGN KEY (`expenditureOrganizationId`)
REFERENCES `expenditure_organization_csm` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT;

END IF;
END $$

CALL V20240320185547__Alter_scholarship_accounting_poet_based() $$
DROP PROCEDURE IF EXISTS V20240320185547__Alter_scholarship_accounting_poet_based $$
DELIMITER ;