DELIMITER $$
DROP PROCEDURE IF EXISTS V20240327125001__Insert_StudentDocumentReminderTranslation $$
CREATE PROCEDURE V20240327125001__Insert_StudentDocumentReminderTranslation()
BEGIN

IF NOT EXISTS ((select * from picklist_translation  where `key` ='STUDENT_DOCUMENT_SUBMISSION_REMINDER')) THEN 
INSERT INTO picklist_translation (`key`,`en`) 
VALUES ('STUDENT_DOCUMENT_SUBMISSION_REMINDER', 'Student Document Submission Reminder');
END IF;

IF NOT EXISTS ((select * from picklist_translation  where `key` ='DOCUMENT_SUBMISSION_REMINDER')) THEN 
INSERT INTO picklist_translation (`key`,`en`) 
VALUES ('DOCUMENT_SUBMISSION_REMINDER', 'Document Submission Reminder');
END IF;

IF NOT EXISTS ((select * from picklist_translation  where `key` ='DOCUMENT_SUBMISSION_REMINDER_RCPNT')) THEN 
INSERT INTO picklist_translation (`key`,`en`) 
VALUES ('DOCUMENT_SUBMISSION_REMINDER_RCPNT', 'Document Submission Reminder Recipient');
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_DOCUMENT_SUBMISSION_REMINDER')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_DOCUMENT_SUBMISSION_REMINDER', 'Student Document Submission Reminder', 'Student Document Submission Reminder', 'Student Dokument indiening Herinnering', 'Nhắc nhở nộp tài liệu sinh viên',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DOCUMENT_SUBMISSION_REMINDER')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'DOCUMENT_SUBMISSION_REMINDER', 'Document Submission Reminder', 'Document Submission Reminder', 'Herinnering vir die indiening van dokumente', 'Nhắc nhở nộp tài liệu',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DOCUMENT_SUBMISSION_REMINDER_RCPNT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'DOCUMENT_SUBMISSION_REMINDER_RCPNT', 'Document Submission Reminder Recipient', 'Document Submission Reminder Recipient', "Ontvanger van 'n herinnering aan die indiening van dokument", 'Nhắc nhở nộp tài liệu Người nhận',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='DOCUMENT_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'DOCUMENT_NAME', 'Document Name', 'Document Name', 'Dokument Naam', 'Tên tài liệu',now(),1);
END IF; 

END $$
CALL V20240327125001__Insert_StudentDocumentReminderTranslation() $$
DROP PROCEDURE IF EXISTS V20240327125001__Insert_StudentDocumentReminderTranslation $$
DELIMITER ;