DELIMITER $$
DROP PROCEDURE IF EXISTS V20240417151117__Insert_Whether_Group_or_Individual_csm $$
CREATE PROCEDURE V20240417151117__Insert_Whether_Group_or_Individual_csm()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'WHETHER_GROUP_OR_INDIVIDUAL')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'whether_group_or_individual','WHETHER_GROUP_OR_INDIVIDUAL','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'whether_group_or_individual');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemCode','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemValue','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

END IF; 

-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'WHETHER_GROUP_OR_INDIVIDUAL')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'WHETHER_GROUP_OR_INDIVIDUAL', 'Lesson Planning Whether Group or Individual', 'Lesson Planning Whether Group or Individual','Lesbeplanning Hetsy groep of individueel','Lập kế hoạch bài học cho dù nhóm hay cá nhân',now(),1);
END IF; 

END $$
CALL V20240417151117__Insert_Whether_Group_or_Individual_csm() $$
DROP PROCEDURE IF EXISTS V20240417151117__Insert_Whether_Group_or_Individual_csm $$
DELIMITER ;