DELIMITER $$
DROP PROCEDURE IF EXISTS V20240514141107__Create_StdJourneyAuditdetail $$
CREATE PROCEDURE V20240514141107__Create_StdJourneyAuditdetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_journey_audit_details')) THEN
CREATE TABLE `student_journey_audit_details` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint NOT NULL,
  `programId` bigint NOT NULL,
  `programBatchId` bigint NOT NULL,
  `periodId` bigint NOT NULL,
  `seatTypeId` bigint DEFAULT NULL,
  `fromPeriodId` bigint DEFAULT NULL,
  `fromBatchId` bigint DEFAULT NULL,
  `academyCampusId` bigint DEFAULT NULL,
  `academicTermId` bigint DEFAULT NULL,
  `admissionId` bigint DEFAULT NULL,
  `studentId` bigint DEFAULT NULL,
  `periodStatus` varchar(255) DEFAULT NULL,
  `resultStatus` varchar(255) DEFAULT NULL,
  `enrollmentStatus` varchar(255) DEFAULT NULL,
  `isReturn` tinyint(1) DEFAULT '0',
  `studentStatus` tinyint(1) DEFAULT '0',
  `version` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  `isPeriodEnrolled` bit(1) DEFAULT NULL,
  `isLeaveOfAbsencePeriod` bit(1) DEFAULT NULL,
  `programJourneySeq` int DEFAULT NULL,
  `isStudentJourney` tinyint(1) DEFAULT '0',
  `isPublishedEnrollmentStatus` bit(1) DEFAULT b'0',
  `fromAdmissionId` bigint DEFAULT NULL,
  `fromAcademyLocationId` bigint DEFAULT NULL,
  `progressionStatusId` bigint DEFAULT NULL,
  `periodEnrollmentSeq` int DEFAULT '0',
  `isActive` bit(1) DEFAULT b'1',
  `periodStatusForJob` varchar(255) DEFAULT NULL,
  `transectionVersion` bigint default null,
  `transectionCode` varchar(255) DEFAULT NULL,
  `changeIndicator` bit(1) DEFAULT false,
  PRIMARY KEY (`id`),
  KEY `fk_academyLocation_Id_idx` (`academyLocationId`),
  KEY `fk_program_Id_idx` (`programId`),
  KEY `fk_program_Batch_Id_idx` (`programBatchId`),
  KEY `fk_academyCampus_Id_idx` (`academyCampusId`),
  KEY `fk_academicTerm_Id_idx` (`academicTermId`),
  KEY `fk_student_Id_idx` (`studentId`),
  KEY `fk_period_Id_idx` (`periodId`),
  KEY `fk_admision_Id_idx` (`admissionId`),
  KEY `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy`),
  KEY `fk_seatType_id_Idx` (`seatTypeId`),
  KEY `fk_std_jry_fromPariod_id_Idx` (`fromPeriodId`),
  KEY `fk_std_jry_fromBatch_id_Idx` (`fromBatchId`),
  KEY `fk_fromAdmissionId_id_idx` (`fromAdmissionId`),
  KEY `fk_fromAcademyLocationId_id_idx` (`fromAcademyLocationId`),
  KEY `progression_status_id_idx` (`progressionStatusId`),
  CONSTRAINT `fk_fromAcademyLocationId` FOREIGN KEY (`fromAcademyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_fromAdmissionId` FOREIGN KEY (`fromAdmissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_seatType` FOREIGN KEY (`seatTypeId`) REFERENCES `prog_batch_seat_config` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_sj_academicTermIdx` FOREIGN KEY (`academicTermId`) REFERENCES `academic_term` (`id`),
  CONSTRAINT `fk_sj_academyCampusIdx` FOREIGN KEY (`academyCampusId`) REFERENCES `academy_location_campus` (`id`),
  CONSTRAINT `fk_sj_academyLocationIdx` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_sj_admissionIdx` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_sj_lastUpdatedx` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_sj_periodIdx` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_sj_programBatchIdx` FOREIGN KEY (`programBatchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_sj_programIdx` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_sj_studentIdx` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
  CONSTRAINT `fk_std_jry_fromBatchIdx` FOREIGN KEY (`fromBatchId`) REFERENCES `batches` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_std_jry_fromPariodIdx` FOREIGN KEY (`fromPeriodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `progression_statusIdx` FOREIGN KEY (`progressionStatusId`) REFERENCES `progression_status` (`id`)
);
END IF;

END $$
CALL V20240514141107__Create_StdJourneyAuditdetail () $$ 
DROP PROCEDURE IF EXISTS V20240514141107__Create_StdJourneyAuditdetail $$ 
DELIMITER ;