DELIMITER $$
DROP PROCEDURE IF EXISTS V20240515111307__Create_payment_link $$
CREATE PROCEDURE V20240515111307__Create_payment_link()
BEGIN


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_link')) THEN 
CREATE TABLE payment_link (
id bigint(20) NOT NULL AUTO_INCREMENT,
totalOutstandingAmount  double(20,3) DEFAULT NULL,
studentId bigint(20) DEFAULT NULL,
encryptedlink  varchar(255) DEFAULT NULL, 
receiptHeaderId bigint(20) DEFAULT NULL, 
creationDateTime datetime DEFAULT NULL,
isExpired BIT NOT NULL DEFAULT b'0',
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (id),


CONSTRAINT `FK_payment_link_FK_studentId` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
CONSTRAINT `FK_payment_link_FK_receiptHeaderId` FOREIGN KEY (`receiptHeaderId`) REFERENCES `receipt_header` (`id`),
CONSTRAINT `FK_payment_link_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF; 

END $$
CALL V20240515111307__Create_payment_link () $$ 
DROP PROCEDURE IF EXISTS V20240515111307__Create_payment_link $$ 
DELIMITER ;


