DELIMITER $$
DROP PROCEDURE IF EXISTS V20240517191509__Create_FacultyInterestReport $$
CREATE PROCEDURE V20240517191509__Create_FacultyInterestReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='faculty_interest_report')) THEN 
CREATE TABLE `faculty_interest_report` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `facultyCourseInterestId` BIGINT NOT NULL,
  `isApproved` BIT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `faculty_interest_report_fk`
    FOREIGN KEY (`facultyCourseInterestId`)
    REFERENCES `faculty_course_interest` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `faculty_interest_report_fk_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='faculty_interest_report' AND column_name='approvedBy')) THEN 
ALTER TABLE  `faculty_interest_report` 
ADD COLUMN `approvedBy` BIGINT NULL;
ALTER TABLE `faculty_interest_report` 
ADD CONSTRAINT `faculty_interest_report_approve`
  FOREIGN KEY (`approvedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='faculty_interest_report' AND column_name='approvedOn')) THEN 
ALTER TABLE `faculty_interest_report` 
ADD COLUMN `approvedOn` DATETIME NULL DEFAULT NULL;
END IF; 

END $$
CALL V20240517191509__Create_FacultyInterestReport () $$ 
DROP PROCEDURE IF EXISTS V20240517191509__Create_FacultyInterestReport $$ 
DELIMITER ;