DELIMITER $$
DROP PROCEDURE IF EXISTS V20240528180527__Alter_AddedStatus $$
CREATE PROCEDURE V20240528180527__Alter_AddedStatus()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_journey_added_status_details')) THEN 
ALTER TABLE student_journey_added_status_details
        DROP FOREIGN KEY fk_student_journey_added_status_details_id,
        DROP FOREIGN KEY fk_student_journey_added_status_details_lastUpdateBy,
        DROP FOREIGN KEY fk_student_journey_added_status_details_studentJourneyid;

        -- Add foreign key constraints without ON DELETE and ON UPDATE restrictions
        ALTER TABLE student_journey_added_status_details
        ADD CONSTRAINT fk_student_journey_added_status_details_id FOREIGN KEY (studentJourneyAddedStatusId) REFERENCES student_journey_added_status (id),
        ADD CONSTRAINT fk_student_journey_added_status_details_lastUpdateBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
        ADD CONSTRAINT fk_student_journey_added_status_details_studentJourneyid FOREIGN KEY (studentJourneyId) REFERENCES student_journey (id)
        ON DELETE CASCADE;
END IF; 

END $$
CALL V20240528180527__Alter_AddedStatus() $$
DROP PROCEDURE IF EXISTS V20240528180527__Alter_AddedStatus $$
DELIMITER ;