DELIMITER $$
DROP PROCEDURE IF EXISTS V20240611154757__Create_Task_Document $$
CREATE PROCEDURE V20240611154757__Create_Task_Document()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='task_documents')) THEN 
CREATE TABLE task_documents (
id bigint(20) NOT NULL AUTO_INCREMENT,
documentId bigint(20) DEFAULT NULL, 
taskId bigint(20) DEFAULT NULL, 
creationDateTime datetime DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (id),

CONSTRAINT `FK_task_documents_FK_documentId` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`),
CONSTRAINT `FK_task_documents_FK_taskId` FOREIGN KEY (`taskId`) REFERENCES `event_meeting_minutes_task` (`id`),
CONSTRAINT `FK_task_documents_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF;


END $$
CALL V20240611154757__Create_Task_Document () $$ 
DROP PROCEDURE IF EXISTS V20240611154757__Create_Task_Document $$ 
DELIMITER ;