DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseToBePushInCanvas $$
CREATE PROCEDURE fatchCourseToBePushInCanvas(jobLastRunTimestamp timestamp)
BEGIN

SELECT 
    course.courseCode AS courseCode,course.courseShortDescription AS courseShortDescription, course.nameToBePrinted AS courseName, course.id AS id,canvasCourse.canvasCourseId AS canvasCourseId, canvasCourse.academyLocationId AS locationId
FROM
    courses AS course 
        LEFT JOIN
    canvas_course_mapping AS canvasCourse ON canvasCourse.academiaCourseId = course.id
        where canvasCourse.id is null and isLMSCourses IS TRUE 
UNION ALL SELECT 
    course.courseCode AS courseCode,course.courseShortDescription AS courseShortDescription, course.nameToBePrinted AS courseName, func_inc_var_session_rec() AS id,canvasCourse.canvasCourseId AS canvasCourseId , canvasCourse.academyLocationId AS locationId
FROM
    courses AS course 
		JOIN
    canvas_course_mapping AS canvasCourse ON canvasCourse.academiaCourseId = course.id
WHERE
    course.lastUpdate > jobLastRunTimestamp and isLMSCourses IS TRUE ;

END $$ 
DELIMITER ;