DELIMITER $$
DROP PROCEDURE IF EXISTS V20240715123938__Insert_ProgramCompletionAwardTypeCSM $$
CREATE PROCEDURE V20240715123938__Insert_ProgramCompletionAwardTypeCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_completion_award_type_csm')) THEN 
CREATE TABLE `program_completion_award_type_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`sequenceNo` INT NOT NULL, 
	`activeStatus` BIT(1) NOT NULL DEFAULT b'1',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `fk_program_completion_award_type_csm_lastUpdatedBy_idx` (`lastUpdatedBy`),
	CONSTRAINT `fk_program_completion_award_type_csm_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 
	-- ------------------CSM DATA-------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'program_completion_award_type_csm')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'program_completion_award_type_csm','PROGRAM_COMPLETION_AWARD_TYPE','Student Profile','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 


IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'program_completion_award_type_csm')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'program_completion_award_type_csm');

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`,`diaplayOrder`, `whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`, `whetherReadOnly`, `wheherNullable`,`lastUpdatedBy`, `lastUpdate`)
VALUES ('sequenceNo', 'SEQUENCE_NO', @standardMasterId,'Number',NULL,3,0,NULL,NULL,NULL,0,0,0,1,now());

INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('activeStatus','ACTIVE_STATUS',@standardMasterId,'Boolean',NULL,4,0,NULL,NULL,NULL,0,0,0,1,now());
END IF; 

-- ------------------TRANSLATION-------------------------------------------------
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' AND keyName = 'PROGRAM_COMPLETION_AWARD_TYPE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'PROGRAM_COMPLETION_AWARD_TYPE', 'Program Completion Award Type', 'Program Completion Award Type','Programvoltooiing Toekenning Tipe','Loại giải thưởng hoàn thành chương trình',now(),1);
END IF; 

END $$
CALL V20240715123938__Insert_ProgramCompletionAwardTypeCSM() $$
DROP PROCEDURE IF EXISTS V20240715123938__Insert_ProgramCompletionAwardTypeCSM $$
DELIMITER ;