DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseStMappingCanvasST $$
CREATE PROCEDURE fatchCourseStMappingCanvasST()
BEGIN
	SELECT 
    func_inc_var_session_rec() AS `id`,
	usr.id AS 'studentId',
    usr.code AS 'studentCode',
    adm.id AS 'admissionId',
    adm.code AS 'admissionCode',
    period.id AS 'periodId',
    param_cv.id AS 'courseVariantsId',
    cum.canvasUserId AS 'canvasUserId',
    ccsm.canvasCourseSectionId AS 'canvasCourseSectionId',
    1 AS 'locationId'
    from student_course_enrollment as sce
	JOIN admission adm ON sce.admissionId = adm.id
    JOIN users usr ON usr.id = adm.studentId
    JOIN prog_batch_period_config period ON sce.programBatchPeriodConfigId = period.id
	JOIN course_variants param_cv ON param_cv.id = sce.courseVarientId
	JOIN courses cours ON param_cv.courseId = cours.id AND cours.isLMSCourses=true
	JOIN canvas_user_mapping cum ON  cum.academiaUserId = usr.id
    JOIN canvas_course_section_mapping ccsm ON  ccsm.academiaCourseVariantId = param_cv.id
	LEFT JOIN canvas_user_course_section_mapping cucsm ON  cucsm.academiaUserId = usr.id AND cucsm.academiaCourseVariantId = param_cv.id
	WHERE cucsm.id is null and sce.exitDate is null;
END $$ 
DELIMITER ;