DELIMITER $$
DROP PROCEDURE IF EXISTS V20240806145041__Create_KCU_STUDENT_ID_CARD $$
CREATE PROCEDURE V20240806145041__Create_KCU_STUDENT_ID_CARD()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'KCU_STUDENT_ID_CARD')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('7', 'KCU_STUDENT_ID_CARD', 'KCU Student Id Card', 'KCU_STUDENT_ID_CARD.png', 'CommonReport_KCU_STUDENT_ID_CARD.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'KCU_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='KCU_STUDENT_ID_CARD'))) THEN
	set @stuId = (select id from report_template where templateCode ='KCU_STUDENT_ID_CARD');
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@stuId, 'TRANS_NAME', 'Name', '1', NOW()),
	(@stuId, 'TRANS_REG_NO', 'Reg No', '1', NOW()),
	(@stuId, 'TRANS_RESEARCHER', 'Researcher', '1', NOW()),
	(@stuId, 'TRANS_NATIONALITY', 'Nationality', '1', NOW()),
	(@stuId, 'TRANS_DATE_OF_BIRTH', 'Date Of Birth', '1', NOW()),
	(@stuId, 'TRANS_STUDENT_ID_NO', 'Student ID No.', '1', NOW()),
	(@stuId, 'TRANS_ISSUING_DATE', 'Issuing Date', '1', NOW()),
	(@stuId, 'TRANS_K_CEASOR', 'KING CEASOR', '1', NOW()),
	(@stuId, 'TRANS_UNIVERSITY', 'UNIVERSITY', '1', NOW()),
	(@stuId, 'TRANS_ISSUE_OFFFICER', 'Issuing Officer', '1', NOW()),
	(@stuId, 'TRANS_UNIVERSITY_NAME', 'KING CEASOR UNIVERSITY', '1', NOW()),
	(@stuId, 'TRANS_SUMMERY', 'If found please return to the above address or the nearest police station.', '1', NOW()),
	(@stuId, 'TRANS_EXPIRY_DATE', 'Expiry Date', '1', NOW());
  END IF;
END $$
CALL V20240806145041__Create_KCU_STUDENT_ID_CARD () $$ 
DROP PROCEDURE IF EXISTS V20240806145041__Create_KCU_STUDENT_ID_CARD $$ 
DELIMITER ;