DELIMITER $$
DROP PROCEDURE IF EXISTS V20240813170905__Insert_GovermentSponsorTranslation $$
CREATE PROCEDURE V20240813170905__Insert_GovermentSponsorTranslation()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='ui_translation')) THEN 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='GOVERMENT_SPONSOR')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','GOVERMENT_SPONSOR','Government Sponsor','Government Sponsor','Staatsborg','Nhà tài trợ chính phủ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PERSON' and keyName='GOVERMENT_SPONSOR')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PERSON','GOVERMENT_SPONSOR','Government Sponsor','Government Sponsor','Staatsborg','Nhà tài trợ chính phủ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='cb' and keyName='government_sponsor_csm')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('cb','government_sponsor_csm','Government Sponsor','Government Sponsor','Staatsborg','Nhà tài trợ chính phủ',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='cb' and keyName='government_sponsor_csm_item_code')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('cb','government_sponsor_csm_item_code','Government Sponsor Item Code','Government Sponsor Item Code','Staatsborgitemkode','Mã hạng mục nhà tài trợ chính phủ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='cb' and keyName='government_sponsor_csm_item_value')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('cb','government_sponsor_csm_item_value','Government Sponsor Item Value','Government Sponsor Item Value','Staatsborgitemwaarde','Giá trị hạng mục tài trợ của chính phủ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='cb' and keyName='government_sponsor_csm_sequenceNo')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('cb','government_sponsor_csm_sequenceNo','Government Sponsor Sequence No','Government Sponsor Sequence No','Regeringsborg Volgorde No','Trình tự tài trợ của chính phủ Không',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='cb' and keyName='government_sponsor_csm_governmentSponsorActive')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('cb','government_sponsor_csm_governmentSponsorActive','Government Sponsor Active','Government Sponsor Active','Regeringsborg aktief','Nhà tài trợ chính phủ đang hoạt động',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='cb' and keyName='government_sponsor_csm_lastUpdate')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('cb','government_sponsor_csm_lastUpdate','Government Sponsor Last Update','Government Sponsor Last Update','Staatsborg Laaste Update','Nhà tài trợ chính phủ Cập nhật lần cuối',now(),1);
END IF;

END IF; 

END $$
CALL V20240813170905__Insert_GovermentSponsorTranslation() $$
DROP PROCEDURE IF EXISTS V20240813170905__Insert_GovermentSponsorTranslation $$
DELIMITER ;