DELIMITER $$
DROP PROCEDURE IF EXISTS V20240905160723__Create_CalculateAverageLevelWise $$
CREATE PROCEDURE V20240905160723__Create_CalculateAverageLevelWise()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='calculate_average_level_wise')) THEN 
CREATE TABLE `calculate_average_level_wise` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `sequenceHeaderId` BIGINT NOT NULL,
  `average` FLOAT NOT NULL,
  `json` TEXT NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_calculate_average_level_wise_admissionId_idx` (`admissionId`) ,
  INDEX `fk_calculate_average_level_wise_batchId_idx` (`batchId`) ,
  INDEX `fk_calculate_average_level_wise_sequenceHeaderId_idx` (`sequenceHeaderId`) ,
  INDEX `fk_calculate_average_level_wise_lastupdateby_idx` (`lastUpdatedBy`) ,
  UNIQUE INDEX `fk_calculate_average_level_wise_unique_idx` (`admissionId` , `batchId` , `sequenceHeaderId`) ,
  CONSTRAINT `fk_calculate_average_level_wise_admissionId`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_calculate_average_level_wise_batchId`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_calculate_average_level_wise_sequenceHeaderId`
    FOREIGN KEY (`sequenceHeaderId`)
    REFERENCES `sequence_header` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_calculate_average_level_wise_lastupdateby`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20240905160723__Create_CalculateAverageLevelWise () $$ 
DROP PROCEDURE IF EXISTS V20240905160723__Create_CalculateAverageLevelWise $$ 
DELIMITER ;