DELIMITER $$
DROP PROCEDURE IF EXISTS V20240910123539__Create_ReadmServiceRequestExecutionEvent $$
CREATE PROCEDURE V20240910123539__Create_ReadmServiceRequestExecutionEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='READMISSION_SERVICE_REQUEST_EXECUTION')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SERVICE_REQUEST');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'READMISSION_SERVICE_REQUEST_EXECUTION');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='READMISSION_SERVICE_REQUEST_EXECUTION');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'READMISSION_SERVICE_REQUEST_EXECUTION', 'Readmission Service Request Execution', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Readmission Service Request Execution');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'READMISSION_SERVICE_REQUEST_EXECUTION_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT', 'SQL');
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT');
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='READMISSION_SERVICE_REQUEST_EXECUTION_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='READMISSION_SERVICE_REQUEST_EXECUTION_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id AS USER_ID FROM execution_details T1 WHERE T1.id IN (namedParams)",NULL);
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
	T5.printName AS PRINT_NAME,
	T5.firstName AS FIRST_NAME,
	T5.middleName AS MIDDLE_NAME,
	T5.lastName AS LAST_NAME,
	T5.printName AS STUDENT_PRINT_NAME,
	T5.firstName AS STUDENT_FIRST_NAME,
	T5.middleName AS STUDENT_MIDDLE_NAME,
	T5.lastName AS STUDENT_LAST_NAME,
	T3.code AS STUDENT_ID,
	T5.emailId AS EMAIL_ID,
	T5.mobileCountryCode as MOBILE_CODE,
    T5.mobileNumber as MOBILE_NO,
	T5.externalSysRefOne AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
	T6.salutationName AS SERVICE_REQUEST_SALUTATION,
	T5.initials AS INITIALS,
	T14.itemValue AS ACADEMIC_YEAR,
	T13.displayName AS ACADEMY_LOCATION,
	T11.programNameToBePrint AS PROGRAM,
	T10.printName AS BATCH,
	T12.printName AS PERIOD,
	T7.reasonCode AS SERVICE_REQUEST_REASON,
	T1.remarks AS REMARKS,
	(SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T3.id) AS DEVICE_ID
FROM
    execution_details T1
		LEFT OUTER JOIN
	service_requests T2 on T2.id = T1.serviceRequestId
		LEFT OUTER JOIN
	users T3 on T3.id = T2.requester
		LEFT OUTER JOIN
	students T4 on T4.userId = T3.id
		LEFT OUTER JOIN
	persons T5 on T5.id = T4.personId
		LEFT OUTER JOIN
	salutations T6 on T6.id = T5.salutationId
		LEFT OUTER JOIN
	closure_reason T7 on T7.id = T1.closureReasonId
		LEFT OUTER JOIN
	admission T8 on T8.studentId = T3.id
		LEFT OUTER JOIN
	program_batch_students T9 on T9.admissionId = T8.id and T9.exitDate is null and T9.isPeriodCompleted = false
		LEFT OUTER JOIN
	batches T10 on T10.id = T9.programBatchId and T10.programId = T2.currentProgram
		LEFT OUTER JOIN
	programs T11 on T11.id = T10.programId
		LEFT OUTER JOIN
	prog_batch_period_config T12 on T12.id = T9.progBatchPeriodConfigId
		LEFT OUTER JOIN
	academy_location T13 on T13.id = T11.academyLocationId
		LEFT OUTER JOIN
	academic_term T14 on T14.id = T12.academicTermId
		LEFT OUTER JOIN
	multi_language ml on ml.id = T5.correspondence_language   
WHERE
    T1.id IN (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },       
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		{
            "id": 4,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "externalSysRefOne",
            "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "salutationName",
            "resultKey": "SERVICE_REQUEST_SALUTATION",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "initials",
            "resultKey": "INITIALS",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "itemValue",
            "resultKey": "ACADEMIC_YEAR",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "printName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 11
        },{
            "id": 13,
            "value": "printName",
            "resultKey": "PERIOD",
            "displayCode": "",
            "displayOrder": 12
		},{
            "id": 14,
            "value": "reasonCode",
            "resultKey": "SERVICE_REQUEST_REASON",
            "displayCode": "",
            "displayOrder": 13
		},{
            "id": 15,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='READMISSION_SERVICE_REQUEST_EXECUTION_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='READMISSION_SERVICE_REQUEST_EXECUTION');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='READMISSION_SERVICE_REQUEST_EXECUTION');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Readmission Service Request Execution',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Readmission Service Request Execution',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','','');

END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='READMISSION_SERVICE_REQUEST_EXECUTION')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'READMISSION_SERVICE_REQUEST_EXECUTION', 'Readmission Service Request Execution', 'Readmission Service Request Execution', 'Uitvoering van hertoelatingsdiensversoek', 'Thực hiện yêu cầu dịch vụ tiếp nhận lại',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='READMISSION_SERVICE_REQUEST_EXECUTION_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'READMISSION_SERVICE_REQUEST_EXECUTION_DL', 'Readmission Service Request Execution DL', 'Readmission Service Request Execution DL', 'Hertoelatingsdiensversoek Uitvoering DL', 'Thực thi yêu cầu dịch vụ tái nhập học DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT', 'Readmission Service Request Execution Recipient', 'Readmission Service Request Execution Recipient', 'Ontvanger van uitvoering van hertoelatingsdiensversoek', 'Người nhận thực hiện yêu cầu dịch vụ tái tiếp nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='READMISSION_SERVICE_REQUEST_EXECUTION')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('READMISSION_SERVICE_REQUEST_EXECUTION', 'Readmission Service Request Execution');
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='READMISSION_SERVICE_REQUEST_EXECUTION_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('READMISSION_SERVICE_REQUEST_EXECUTION_DL', 'Readmission Service Request Execution DL');
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT', 'Readmission Service Request Execution Recipient');
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SERVICE_REQUEST_SALUTATION')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SERVICE_REQUEST_SALUTATION', 'Salutation', 'Salutation', 'Aanhef', 'Lời chào',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SERVICE_REQUEST_REASON')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SERVICE_REQUEST_REASON', 'Reason', 'Reason', 'Rede', 'Lý do',now(),1);
END IF;

END $$
CALL V20240910123539__Create_ReadmServiceRequestExecutionEvent () $$ 
DROP PROCEDURE IF EXISTS V20240910123539__Create_ReadmServiceRequestExecutionEvent $$ 
DELIMITER ;