DELIMITER $$
DROP PROCEDURE IF EXISTS V20240911162920__Insert_StudentProfileUpdateLoader $$
CREATE PROCEDURE V20240911162920__Insert_StudentProfileUpdateLoader()
BEGIN

IF EXISTS ((SELECT * FROM import_utility_master WHERE code = 'studentProfileUpdate')) THEN 
SET @masterId = (select id from import_utility_master WHERE code='studentProfileUpdate');

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='STD_PRFL_ACADEMIC_BANK_CREDITS_HEADER' AND isSchool=0)) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('STD_PRFL_ACADEMIC_BANK_CREDITS_HEADER','Academic Bank of Credits (ABC)','Academic Bank of Credits (ABC)',0,now(),1,0,0,@masterId,0,NULL) ;
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='STD_PRFL_NAAD_STUDENT_HEADER' AND isSchool=0)) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('STD_PRFL_NAAD_STUDENT_HEADER','Naad Student','Naad Student',0,now(),1,0,0,@masterId,0,NULL) ;
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='STD_PRFL_COA_STUDENT_HEADER' AND isSchool=0)) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('STD_PRFL_COA_STUDENT_HEADER','Coa Student','Coa Student',0,now(),1,0,0,@masterId,0,NULL) ;
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='STD_PRFL_ACADEMIC_BANK_CREDITS_HEADER' AND isSchool=1)) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('STD_PRFL_ACADEMIC_BANK_CREDITS_HEADER','Academic Bank of Credits (ABC)','Academic Bank of Credits (ABC)',1,now(),1,0,0,@masterId,0,NULL) ;
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='STD_PRFL_NAAD_STUDENT_HEADER' AND isSchool=1)) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('STD_PRFL_NAAD_STUDENT_HEADER','Naad Student','Naad Student',1,now(),1,0,0,@masterId,0,NULL) ;
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='STD_PRFL_COA_STUDENT_HEADER' AND isSchool=1)) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('STD_PRFL_COA_STUDENT_HEADER','Coa Student','Coa Student',1,now(),1,0,0,@masterId,0,NULL) ;
END IF;

END IF;
END $$
CALL V20240911162920__Insert_StudentProfileUpdateLoader() $$
DROP PROCEDURE IF EXISTS V20240911162920__Insert_StudentProfileUpdateLoader $$
DELIMITER ;