DELIMITER $$
DROP PROCEDURE IF EXISTS V20240925130249__Create_CampusCode_CSM $$
CREATE PROCEDURE V20240925130249__Create_CampusCode_CSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='Manage_Section_CampusCode')) THEN 
CREATE TABLE `Manage_Section_CampusCode` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `code` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Manage_Section_CampusCode_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_Manage_Section_CampusCode_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'Manage_Section_CampusCode','MANAGE_SECTION_CAMPUSCODE','General','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'MANAGE_SECTION_CAMPUSCODE', @standardMasterMaxId+1, 'Boolean', '1', 0, 0, 0, 0, '1', SYSDATE());

insert into Manage_Section_CampusCode (`code`,`lastUpdate`,`lastUpdatedBy`) values(false,SYSDATE(),1);

END IF; 


END $$
CALL V20240925130249__Create_CampusCode_CSM () $$ 
DROP PROCEDURE IF EXISTS V20240925130249__Create_CampusCode_CSM $$ 
DELIMITER ;