DELIMITER $$
DROP PROCEDURE IF EXISTS V20241003162127__Create_Transaction_File_Logger $$
CREATE PROCEDURE V20241003162127__Create_Transaction_File_Logger()
BEGIN
IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='transaction_file_logger') THEN 
CREATE TABLE transaction_file_logger (
    id BIGINT(20) NOT NULL AUTO_INCREMENT,
    transactionDate DATE NOT NULL,
    filePath VARCHAR(255) NOT NULL,
    isSent BOOLEAN NOT NULL DEFAULT FALSE,
	lastUpdatedBy bigint(20) NOT NULL,
	lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
	CONSTRAINT `fk_transaction_file_logger_lastupdateby`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20241003162127__Create_Transaction_File_Logger () $$ 
DROP PROCEDURE IF EXISTS V20241003162127__Create_Transaction_File_Logger $$ 
DELIMITER ;