DELIMITER $$
DROP PROCEDURE IF EXISTS V20241007110554__Create_SendAccStmtToSponsor $$
CREATE PROCEDURE V20241007110554__Create_SendAccStmtToSponsor()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='send_account_stmt_to_sponsor')) THEN 
CREATE TABLE `send_account_stmt_to_sponsor`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`studentId` BIGINT(20) NOT NULL,
	`sponsorContactId` BIGINT(20) NULL,
	`scholarshipId` BIGINT(20) NOT NULL,
	`accountingYearId` BIGINT(20) NOT NULL,
	`statementFrom` DATE NULL,
	`statementTo` DATE NULL,
	`emailType` VARCHAR(10) NULL,
	`language` VARCHAR(10) NOT NULL,
	`documentPath` VARCHAR(255) NULL,
	`status` VARCHAR(10) NOT NULL,
	`failureReason` VARCHAR(255) NULL,
	`statementEmailFilterId` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`), 
	CONSTRAINT `send_stmt_to_sponsor_studentId_FK` FOREIGN KEY (`studentId`) REFERENCES `users`(`id`),
	CONSTRAINT `send_stmt_to_sponsor_sponsorContactId_FK` FOREIGN KEY (`sponsorContactId`) REFERENCES `sponsor_contacts`(`id`),
	CONSTRAINT `send_stmt_to_sponsor_scholarshipId_FK` FOREIGN KEY (`scholarshipId`) REFERENCES `scholarship`(`id`),
	CONSTRAINT `send_stmt_to_sponsor_accountingYearId_FK` FOREIGN KEY (`accountingYearId`) REFERENCES `accounting_year`(`id`),
	CONSTRAINT `send_stmt_to_sponsor_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=INNODB;
END IF; 

END $$
CALL V20241007110554__Create_SendAccStmtToSponsor () $$ 
DROP PROCEDURE IF EXISTS V20241007110554__Create_SendAccStmtToSponsor $$ 
DELIMITER ;